/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "app.h"
#include "definitions.h"    //K{      

#include "stdio.h"
#include "1lcd_lib_XC32.h"
#include "lcd_ACM1602_lib_i2c.h"
#include "INT070_Touch_lib_XC32.h"


int delay_Clock = 200000000;   //VXeNbNF200MHz
char Buf[64];
bool WideUseMojuleBoard;    //ėpW[]{[hڑĂꍇF1

int adcX,adcY;  //^b`Wx,y
int cTouched;   //^b`1
int prevTouched;    //ꏄÓ@^b` '1'A@^b`Ȃ '0'
int prev_abcX, prev_abcY;   //1TCNÕ^b`Wx,y

SYS_TIME_HANDLE StringChange_handle;   //Scr1 ^Cg؂ւ^C}
int ScreenNum;  //XN[ԍ
int Mode1;  //ʂ̕\񃂁[h
int OneShotFlag_Scr0NextBtn;

extern SYS_TIME_HANDLE PictureCycle_handle;
extern int OneShotFlag_Scr1NextBtn; //{^듮h~Vbg^C}tO


void delay_us(volatile unsigned int usec)        //1secx
{
        volatile  int count;
        count = (int)(delay_Clock/20000000)*usec;
        
        do      //@at@200MH (Clock=200000000)
        {       //delay_us(1000)F1000.4sec  delay_us(100)F100.6sec  delay_us(10):10.5sec@@delay_us(1)F1.5sec
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");asm("NOP");
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");

                count--;
        }while(count != 0);
}

void delay_ms(volatile unsigned int msec)        //1msecx
{
        volatile unsigned int i;         //Fat200MH (Clock=200000000)//delay_ms(1)F 1.0006msec   delay_ms(100)F100.04msec

        for(i=0; i<msec; i++)
        delay_us(1000);
}


void All_LedOff(void)   //SLED
{
    LATGbits.LATG15 = 0; //RG15: LED1
    LATDbits.LATD4 = 0;  //RD4: LED2
    LATAbits.LATA15 = 0;  //RA15: LED3
    LATAbits.LATA14 = 0; //RA14: LED4
}

void All_LedOn(void)    //SLED_
{
    LATGbits.LATG15 = 1;    //RG15: LED1_
    LATDbits.LATD4 = 1;     //RD4: LED2_
    LATAbits.LATA15 = 1;    //RA15: LED3_
    LATAbits.LATA14 = 1;    //RA14: LED4_
}



void StringChange ( uintptr_t context )     //VXe^C}(CoreTimer)
                                                       //2000msec̃R[obNi荞݁j
{
    if(Mode1 == false)    
    {
        Mode1 = true;
        //(Screen0)̃x\F <Harmony Ver.3>ALCD INT035Aby Legato
        Screen0_LabelWidget0->fn->setString(Screen0_LabelWidget0, (leString*)&string_Harmony_Ver3);
        Screen0_LabelWidget1->fn->setString(Screen0_LabelWidget1, (leString*)&string_Touch_LCD_INT070);
        Screen0_LabelWidget2->fn->setString(Screen0_LabelWidget2, (leString*)&string_by_Legato);
        
        lcd_cmd(0x80);          //1ڂ̐擪
        sprintf(Buf,"4bit parallel     ");//
        lcd_str(Buf);                   //t\
        lcd_cmd(0xC0);          //Qsڂ̐擪
        sprintf(Buf,"   control LCD    ");	//
        lcd_str(Buf);           // JnbZ[W1sڕ\
        
        if(WideUseMojuleBoard == true)
        {
            lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
            lcd_ACM1602_str_i2c("I2C control       ");
            lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
            lcd_ACM1602_str_i2c("          LCD             ");
        
            All_LedOff();    //SLED
        }
    }
    else 
    {
        Mode1 = false;
        //(Screen0)̃x\F Welcome toAPIC32MZAEvaluation Board
        Screen0_LabelWidget0->fn->setString(Screen0_LabelWidget0, (leString*)&string_Welcome_to);
        Screen0_LabelWidget1->fn->setString(Screen0_LabelWidget1, (leString*)&string_PIC32MZ_Evaluation_Board);
        Screen0_LabelWidget2->fn->setString(Screen0_LabelWidget2, (leString*)&string_INT070_inchi7_0_800x480pixel);
        
        lcd_cmd(0x80);          //1ڂ̐擪
        sprintf(Buf,"Touch Position   ");//
        lcd_str(Buf);                   //t\
        lcd_cmd(0xC0);          //Qsڂ̐擪
        sprintf(Buf,"    (X,Y)        ");	//
        lcd_str(Buf);           // JnbZ[W1sڕ\
        
        if(WideUseMojuleBoard == true)
        {   
            lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
            lcd_ACM1602_str_i2c("Welcome to            ");
            lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
            lcd_ACM1602_str_i2c("    PIC32MZ          ");
        
            All_LedOn();    //SLED_
               
        }
    }
}

     
void ys_DRV_TOUCH_INT070(void)    //MSP2807^b`o  //^b`oA^b`ށA^b`ʒuƃVXeɒ
{
    cTouched = INT070_TouchDetect();        //^b`oŁ@'1'     //Position detedted
    adcX = ys_TouchGetX();  //^b`ʒuxW
    adcY = ys_TouchGetY();  //^b`ʒuyW
   
     if((prevTouched == 0) && (cTouched == 1)) // Touch: Pressed
     {
         SYS_INP_InjectTouchDown(0,adcX,adcY);  //Touch:Pressed VXeɒ
     }
    
     if(prevTouched == 1)   //ꏄÕ^b`Lꍇ
     {
        if(cTouched == 1)                 // Touch: Moved
        {
            SYS_INP_InjectTouchMove(1,adcX,adcY);   //Touch:MovedVXeɒ
        }
        else                        //Touch: Released
        {
            SYS_INP_InjectTouchUp(0,prev_abcX,prev_abcY);     //touch:UpVXeɒ
        }
     }
    
    ////O̒lێ
     prevTouched = cTouched;       
     prev_abcX = adcX;
     prev_abcX = adcY; 
     
    //^b`ʒuW̃LN^tւ̕\ 
     	if(cTouched)    //^b`L			
		{
            if(adcX<800 && adcY<480) //W\͈: (0,0)-(800,480)̋`w
			{
                    //LN^tɃ^b`ʒuW\
                    lcd_cmd(0x80);          //1ڂ̐擪
                    sprintf(Buf,"Touch Position             \r\n");//
                    //sprintf(Buf,"cTouched=%d              \r\n",cTouched);//
                    lcd_str(Buf);                   //t\
                   
                    lcd_cmd(0xC0);          //Qsڂ̐擪
                    sprintf(Buf,"X=%d, Y=%d                 \r\n",adcX, adcY);	//
                    lcd_str(Buf);           // JnbZ[W1sڕ\
            }
		}else     	
        { 
            delay_ms(10);
        } 
}


// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_Initialize function.

    Application strings and buffers are be defined outside this structure.
*/

APP_DATA appData;

// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************

/* TODO:  Add any necessary callback functions.
*/

// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************


/* TODO:  Add any necessary local functions.
*/


// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_Initialize ( void )

  Remarks:
    See prototype in app.h.
 */

void APP_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    appData.state = APP_STATE_INIT;



    /* TODO: Initialize your application's state machine and other
     * parameters.
     */
    ys_TouchHardwareInit(); //^b` 
    
       	
    lcd_init();				// LCD
    lcd_cmd(0b00001100);    // J[\:OFF  uݸ:OFF        
    lcd_clear(); 
    
    lcd_cmd(0x80);          //1ڂ̐擪
    sprintf(Buf,"PIC32MZ2048-     ");//
    lcd_str(Buf);                   //t\
    lcd_cmd(0xC0);          //Qsڂ̐擪
    sprintf(Buf,"   EFH100 booted");	//
    lcd_str(Buf);           // JnbZ[W1sڕ\
    
   EBIMSK0 = 0x28;         //K{@gfx:OK I2C2:OK   //SRAM 8MBpƂāAEBICS0Ȃ[hEBI𓮍삳 
    
    
// ėpW[]{[hiiς݃{[hj̐ڑL`FbN  
    I2C2CONbits.ON = 0;      //IC2W[FOFF
    TRISAbits.TRISA2 = 1;
    TRISAbits.TRISA3 = 1;
    
    if((PORTAbits.RA2 == 0) || (PORTAbits.RA3 == 0))
    {
        WideUseMojuleBoard = false; //ėpW[]{[hiiς݃{[hj͐ڑĂȂB
        lcd_cmd(0x80);          //1ڂ̐擪
        sprintf(Buf," I2C LCD is      ");//
        lcd_str(Buf);                   //t\

        lcd_cmd(0xC0);          //Qsڂ̐擪
        sprintf(Buf,"  NOT availabe   ");	//
        lcd_str(Buf);           // JnbZ[W1sڕ\
        
        delay_ms(2000);  
        
    }
    else
    {
        WideUseMojuleBoard = true;   //ėpW[]{[hiiς݃{[hj͐ڑĂB
        
        I2C2CONbits.ON = 1;      //IC2W[FON
        
        lcd_ACM1602_init_i2c();     //I2CC^[tF[Xt
        lcd_ACM1602_cmd_i2c(0x0C);    //J[\F0FFAuNF0FF
        
        lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
        lcd_ACM1602_str_i2c("Harmony Ver.3           ");
        lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
        lcd_ACM1602_str_i2c(" Legato Start !!        ");
   }
}


/******************************************************************************
  Function:
    void APP_Tasks ( void )

  Remarks:
    See prototype in app.h.
 */

void APP_Tasks ( void )
{

    /* Check the application's current state. */
    switch ( appData.state )
    {
        /* Application's initial state. */
        case APP_STATE_INIT:
        {
            bool appInitialized = true;


            if (appInitialized)
            {
                StringChange_handle = SYS_TIME_CallbackRegisterMS(StringChange, 0, 2000, SYS_TIME_PERIODIC);  
                                                    //2000msecsystemTimer_Callback֐Ăяo悤ɐݒ

                appData.state = APP_STATE_SERVICE_TASKS;
            }
            break;
        }

        case APP_STATE_SERVICE_TASKS:
        {
             //}`TCNɉACӂ̉tʃ^b`o    //
            if((cTouched == 1) &&
               (OneShotFlag_Scr1NextBtn == 0) && (OneShotFlag_Scr0NextBtn == 0) &&  //SW`^Oh~
               ((ScreenNum == 2) || (ScreenNum == 3) || (ScreenNum == 4) || (ScreenNum == 5)))
            {
                SYS_TIME_TimerStop(PictureCycle_handle);    //}`TCNp^C}~
               legato_showScreen(screenID_Screen0); //TOPʂ֖߂ 
                ScreenNum = 0;
                SYS_TIME_TimerStart(StringChange_handle);
                Mode1 = 1;
                All_LedOff();    //SLED
                SYS_TIME_TimerDestroy(PictureCycle_handle);
                if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
                {
                    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                    lcd_ACM1602_str_i2c("                  ");
                    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                    lcd_ACM1602_str_i2c("                  ");
                }
            }
            break;
        }

        /* TODO: implement your application state machine.*/


        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}


/*******************************************************************************
 End of File
 */
